/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.LinkLayerCompTest;

import com.quantumdata.LinkLayerCompTest.CustomDialog;
import com.quantumdata.LinkLayerCompTest.llctGui;
import com.quantumdata.std.InstrumentException;
import com.quantumdata.widgets.QDButton;
import com.quantumdata.widgets.QDCheckBox;
import com.quantumdata.widgets.QDLabel;
import com.quantumdata.widgets.QDPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SourcePage
extends QDPanel
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 345678900009876543L;
    private String[] SourceTestNums = new String[]{"4.2.1.1  - Source DUT retry on no-reply during Aux read after Hot Plug event", "4.2.1.2  - Source retry on invalid reply during Aux read after Hot Plug event", "4.2.2.1  - EDID read upon Hot Plug event", "4.2.2.2  - DPCD receiver capability read upon Hot Plug event", "4.2.2.3  - EDID read", "4.2.2.4  - EDID read failure #1: I2C-Over-AUX NACK", "4.2.2.5  - EDID read failure #2: I2C-Over-AUX DEFER", "4.2.2.6  - EDID corruption detection", "4.3.1.1  - Successful link training upon Hot Plug detect", "4.3.1.2  - Successful link training at all supported lane counts and link speeds", "4.3.1.3  - Successful link training with request of higher differential voltage swing during clock recovery sequence", "4.3.1.4  - Successful link training to a lower link rate #1: Iterate at maximum voltage swing", "4.3.1.5  - Successful link training to a lower link rate #2: Iterate at minimum voltage swing", "4.3.1.6  - Successful link training with request of higher pre-emphasis setting during channel equalization sequence", "4.3.1.7  - Successful link training to a lower link rate due to loss of symbol lock during channel equalization sequence", "4.3.1.8  - Unsuccessful link training to a lower link rate #1: Iterate at maximum voltage swing", "4.3.1.9  - Unsuccessful link training to a lower link rate #2: Iterate at minimum voltage swing", "4.3.1.10 - Unsuccessful link training due to failure in channel equalization sequence (loop count > 5)", "4.3.2.1  - Successful link re-training after IRQ_HPD pulse due to loss of symbol lock", "4.3.2.2  - Successful link re-training after IRQ_HPD pulse due to loss of clock recovery", "4.3.2.3  - Successful link re-training after IRQ_HPD pulse due to loss of inter-lane alignment lock", "4.3.2.4  - No link re-training required after IRQ_HPD pulse", "4.3.2.5  - Lane count reduction", "4.3.2.6  - Lane count increase", "4.4.1.1  - Pixel data packing and steering", "4.4.1.2  - Main stream data packing and stuffing - least packed TU", "4.4.1.3  - Main stream data packing and stuffing - most packed TU", "4.4.2    - Main video stream format change handling", "4,4,3    - Power Management"};
    private String[] sPopupMessages = new String[]{"Please elicit an EDID read from the DUT.", "Please set link rate and lane count to the maximum suppored values.", "Please put the DUT into Power Save mode.", "Please take the DUT out of Power Save mode.", "Please give input", "Please output: RAMP pattern as defined in DP spec, RGB VESA, 6bpc.", "Please output: RAMP pattern as defined in DP spec, RGB VESA, 8bpc.", "Please output: RAMP pattern as defined in DP spec, RGB VESA, 10bpc.", "Please output: Color Square pattern defined in the DP spec, RGB CEA, 8bpc.", "Please output: Color Square pattern defined in the DP spec, RGB CEA, 10bpc.", "Please output: Color Square pattern defined in the DP spec, YCbCr422, 8bpc.", "Please output: Color Square pattern defined in the DP spec, YCbCr422, 10bpc.", "Please output: Color Square pattern defined in the DP spec, YCbCr444, 8bpc.", "Please output: Color Square pattern defined in the DP spec, YCbCr444, 10bpc.", "Please output video: 640x480p @60Hz (Fail-Safe settings)", "Please output video: CVT 1280x800p @60Hz, Reduced Mode.", "Please output video: DMT 1280x768p @60Hz, Reduced Mode.", "Please output video: DMT 800x600p @60Hz, Normal Mode.", "Please output video: DMT 1024x768p @60Hz, Normal Mode.", "Please output video: DMT 1280x1024p @60Hz, Normal Mode.", "Please output video: DMT 1280x960p @60Hz, Normal Mode.", "Please output video: DMT 1360x768p @60Hz, Normal Mode.", "Please output video: CVT 1280x800p @60Hz, Normal Mode.", "Please output video: DMT 1400x1050p @60Hz, Reduced Mode.", "Please output video: DMT 1280x768p @60Hz, Normal Mode.", "Please output video: CVT 1600x1200p @60Hz, Reduced Mode.", "Please output video: CVT 2048x1536p @60Hz, Reduced Mode.", "Please output video: DMT 1792x1344p @60Hz, Normal Mode.", "Please output video: DMT 1600x1200p @60Hz, Normal Mode.", "Please output video: CEA 1440x480p @59.94Hz.", "Please output video: CEA 1440x576p @50Hz.", "Please output video: CEA 1920x1080i @50Hz.", "Please output video: CEA 1920x1080i @59.94Hz.", "Please output video: CEA 1920x1080i @60Hz.", "Please output video: CEA 1920x1080p @60Hz.", "Please Link train at 1.62Gbs with a lane count of one.", "Please Link train at 1.62Gbs with the lane count set to the maximum supported by the source DUT.", "Please Link train at 1.62Gbs with a lane count of one.", "Please Link train at 1.62Gbs with a lane count of two.", "Please Link train at 1.62Gbs with a lane count of four.", "Please Link train at 2.7Gbs with a lane count of one.", "Please Link train at 2.7Gbs with a lane count of two.", "Please Link train at 2.7Gbs with a lane count of four."};
    private GridBagLayout m_sourceLayout;
    private QDCheckBox[] m_sourceTests;
    private QDCheckBox m_optionalTimeOut;
    private QDCheckBox m_batchMode;
    private QDButton m_selectAllBtn;
    private QDButton m_deselectAllBtn;
    private QDButton m_startTestsBtn;
    private QDButton m_endTestsBtn;
    private QDLabel m_testLbl;
    private QDLabel m_waitTimeLbl;
    private QDLabel m_sumLbl;
    private QDLabel[] m_testStatusLbl;
    private QDLabel m_hpdPulseLbl;
    private JSpinner m_waitTimeSpn;
    private JSpinner m_testItterSpn;
    private JSpinner[] m_itemItterSpn;
    private JSpinner m_hpdPulseDuration;
    private JComboBox m_laneCount;
    private JComboBox m_bitRate;
    private String[] m_lcNames = new String[]{"1 Lane", "2 Lanes", "4 Lanes"};
    private String[] m_brNames = new String[]{"1.62 Gbps", "2.7 Gbps"};
    private llctGui mainWin;
    private CustomDialog aCustomDialog;
    private JFrame aPopupFrame = new JFrame();

    public SourcePage(llctGui llctGui2) {
        this.mainWin = llctGui2;
        this.m_sourceTests = new QDCheckBox[this.SourceTestNums.length];
        this.m_itemItterSpn = new JSpinner[this.SourceTestNums.length];
        this.m_testStatusLbl = new QDLabel[this.SourceTestNums.length];
        this.m_sourceLayout = new GridBagLayout();
        this.setLayout(this.m_sourceLayout);
        Font font = new Font("SansSerif", 0, 10);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        QDPanel qDPanel = new QDPanel();
        qDPanel.setLayout(new BorderLayout());
        this.m_selectAllBtn = new QDButton("Select All");
        this.m_selectAllBtn.addActionListener(this);
        qDPanel.add((Component)this.m_selectAllBtn, "West");
        this.m_deselectAllBtn = new QDButton("Deselect All");
        this.m_deselectAllBtn.addActionListener(this);
        qDPanel.add((Component)this.m_deselectAllBtn, "East");
        this.m_sourceLayout.setConstraints(qDPanel, gridBagConstraints);
        this.add(qDPanel);
        this.m_laneCount = new JComboBox<String>(this.m_lcNames);
        this.m_bitRate = new JComboBox<String>(this.m_brNames);
        this.m_batchMode = new QDCheckBox("Test Automation");
        this.m_optionalTimeOut = new QDCheckBox("Optional 1 Sec Time Out");
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        this.m_sourceLayout.setConstraints(this.m_optionalTimeOut, gridBagConstraints);
        this.m_optionalTimeOut.addActionListener(this);
        this.add(this.m_optionalTimeOut);
        QDPanel qDPanel2 = new QDPanel();
        qDPanel2.setLayout(new BorderLayout());
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        this.m_hpdPulseLbl = new QDLabel(" Long HPD Pulse Width (ms) ");
        this.m_sourceLayout.setConstraints(this.m_hpdPulseLbl, gridBagConstraints);
        qDPanel2.add((Component)this.m_hpdPulseLbl, "West");
        this.m_hpdPulseDuration = new JSpinner();
        this.m_hpdPulseDuration.setValue(new Integer(10));
        this.m_hpdPulseDuration.addChangeListener(this);
        qDPanel2.add((Component)this.m_hpdPulseDuration, "East");
        this.m_sourceLayout.setConstraints(qDPanel2, gridBagConstraints);
        this.add(qDPanel2);
        QDPanel qDPanel3 = new QDPanel();
        qDPanel3.setLayout(new BorderLayout());
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        this.m_waitTimeLbl = new QDLabel(" Time Between Tests (sec)  ");
        this.m_sourceLayout.setConstraints(this.m_waitTimeLbl, gridBagConstraints);
        qDPanel3.add((Component)this.m_waitTimeLbl, "West");
        this.m_waitTimeSpn = new JSpinner();
        this.m_waitTimeSpn.setValue(new Integer(15));
        this.m_waitTimeSpn.addChangeListener(this);
        qDPanel3.add((Component)this.m_waitTimeSpn, "East");
        this.m_sourceLayout.setConstraints(qDPanel3, gridBagConstraints);
        this.add(qDPanel3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        this.m_testLbl = new QDLabel("TESTS");
        this.m_sourceLayout.setConstraints(this.m_testLbl, gridBagConstraints);
        this.add(this.m_testLbl);
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 11;
        this.m_sumLbl = new QDLabel("TEST RESULTS:");
        this.m_sumLbl.setVisible(false);
        this.m_sourceLayout.setConstraints(this.m_sumLbl, gridBagConstraints);
        this.add(this.m_sumLbl);
        for (int i = 0; i < this.SourceTestNums.length; ++i) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = i + 7;
            gridBagConstraints.gridwidth = 5;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 18;
            this.m_sourceTests[i] = new QDCheckBox(this.SourceTestNums[i]);
            this.m_sourceTests[i].setFont(font);
            this.m_sourceTests[i].setSelected(true);
            this.m_sourceLayout.setConstraints(this.m_sourceTests[i], gridBagConstraints);
            this.m_sourceTests[i].addActionListener(this);
            this.add(this.m_sourceTests[i]);
            gridBagConstraints.gridx = 6;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            this.m_itemItterSpn[i] = new JSpinner();
            this.m_itemItterSpn[i].setValue(new Integer(1));
            this.m_itemItterSpn[i].addChangeListener(this);
            this.m_sourceLayout.setConstraints(this.m_itemItterSpn[i], gridBagConstraints);
            this.add(this.m_itemItterSpn[i]);
            gridBagConstraints.gridx = 6;
            gridBagConstraints.anchor = 11;
            this.m_testStatusLbl[i] = new QDLabel(" ");
            this.m_testStatusLbl[i].setForeground(Color.orange);
            this.m_testStatusLbl[i].setVisible(false);
            this.m_sourceLayout.setConstraints(this.m_testStatusLbl[i], gridBagConstraints);
            this.add(this.m_testStatusLbl[i]);
        }
        QDPanel qDPanel4 = new QDPanel();
        qDPanel4.setLayout(new BorderLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 36;
        gridBagConstraints.anchor = 16;
        this.m_startTestsBtn = new QDButton("Start Test");
        this.m_sourceLayout.setConstraints(this.m_startTestsBtn, gridBagConstraints);
        this.m_startTestsBtn.addActionListener(this);
        qDPanel4.add((Component)this.m_startTestsBtn, "West");
        QDLabel qDLabel = new QDLabel("  Number of Times  ");
        qDPanel4.add((Component)qDLabel, "Center");
        this.m_testItterSpn = new JSpinner();
        this.m_testItterSpn.setValue(new Integer(1));
        this.m_testItterSpn.addChangeListener(this);
        this.m_sourceLayout.setConstraints(this.m_testItterSpn, gridBagConstraints);
        qDPanel4.add((Component)this.m_testItterSpn, "East");
        this.m_sourceLayout.setConstraints(qDPanel4, gridBagConstraints);
        this.add(qDPanel4);
        this.m_endTestsBtn = new QDButton("End Tests");
        gridBagConstraints.gridx = 4;
        this.m_sourceLayout.setConstraints(this.m_endTestsBtn, gridBagConstraints);
        this.m_endTestsBtn.addActionListener(this);
        this.add((Component)this.m_endTestsBtn, gridBagConstraints);
        this.aCustomDialog = new CustomDialog(this.aPopupFrame, this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        if (actionEvent.getSource() == this.m_selectAllBtn) {
            for (n = 0; n < this.SourceTestNums.length; ++n) {
                this.m_sourceTests[n].setSelected(true);
                this.m_itemItterSpn[n].setEnabled(true);
            }
        }
        if (actionEvent.getSource() == this.m_deselectAllBtn) {
            for (n = 0; n < this.SourceTestNums.length; ++n) {
                this.m_sourceTests[n].setSelected(false);
                this.m_itemItterSpn[n].setEnabled(false);
            }
        }
        for (n = 0; n < this.SourceTestNums.length; ++n) {
            this.HandleCheckBox(actionEvent, n);
        }
        if (actionEvent.getSource() == this.m_endTestsBtn) {
            try {
                this.mainWin.sendCmd("dprx:ellc");
            }
            catch (InstrumentException instrumentException) {
                this.mainWin.setErrorMsg("Failed Cancel Tests");
                try {
                    this.mainWin.sendCmd("dprx:rset");
                    this.mainWin.sendCmd("dprx:ellc");
                }
                catch (InstrumentException instrumentException2) {
                    this.mainWin.setErrorMsg("Fail Retry Cancel");
                }
            }
        }
        if (actionEvent.getSource() == this.m_startTestsBtn) {
            int n2;
            n = 0;
            this.m_sumLbl.setVisible(false);
            for (n2 = 0; n2 < this.SourceTestNums.length; ++n2) {
                this.m_testStatusLbl[n2].setVisible(false);
                this.m_testStatusLbl[n2].setText(" ");
            }
            for (n2 = 0; n2 < this.SourceTestNums.length; ++n2) {
                if (!this.m_sourceTests[n2].isSelected()) continue;
                try {
                    this.mainWin.sendCmd("dprx:star " + String.valueOf(n) + " " + String.valueOf(n2));
                    this.mainWin.sendCmd("dprx:snar " + String.valueOf(n) + " " + String.valueOf((Integer)this.m_itemItterSpn[n2].getValue()));
                }
                catch (InstrumentException instrumentException) {
                    this.mainWin.setErrorMsg("Failed setup Tests");
                    return;
                }
                ++n;
            }
            try {
                this.mainWin.sendCmd("dprx:star " + String.valueOf(n) + " 255");
                this.mainWin.sendCmd("dprx:snar " + String.valueOf(n) + " 0");
            }
            catch (InstrumentException instrumentException) {
                this.mainWin.setErrorMsg("Failed to close tests");
                return;
            }
            try {
                for (n2 = 1; n2 <= (Integer)this.m_testItterSpn.getValue(); ++n2) {
                    this.mainWin.sendCmd("dprx:llct " + String.valueOf(n2));
                    this.m_sumLbl.setVisible(true);
                    Thread thread = new Thread(new Runnable(){

                        public void run() {
                            block16: for (int i = 0; i < SourcePage.this.SourceTestNums.length; ++i) {
                                if (!SourcePage.this.m_sourceTests[i].isSelected()) continue;
                                int n = 1;
                                int n2 = -1;
                                boolean bl = true;
                                do {
                                    try {
                                        Thread.sleep(500L);
                                        n = SourcePage.this.mainWin.getInt("dprx:lltr? " + String.valueOf(i));
                                    }
                                    catch (InstrumentException instrumentException) {
                                        SourcePage.this.m_testStatusLbl[i].setVisible(true);
                                        SourcePage.this.m_testStatusLbl[i].setText("Instrument Exception");
                                        SourcePage.this.m_testStatusLbl[i].setForeground(Color.red);
                                        bl = false;
                                        SourcePage.this.aCustomDialog.stop();
                                        continue block16;
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    if (n == n2) continue;
                                    n2 = n;
                                    switch (n) {
                                        case 1: {
                                            SourcePage.this.m_testStatusLbl[i].setVisible(true);
                                            SourcePage.this.m_testStatusLbl[i].setText("In Progress");
                                            SourcePage.this.m_testStatusLbl[i].setForeground(Color.orange);
                                            SourcePage.this.aCustomDialog.stop();
                                            break;
                                        }
                                        case 2: {
                                            Color color = new Color(69, 47, 9);
                                            SourcePage.this.m_testStatusLbl[i].setVisible(true);
                                            SourcePage.this.m_testStatusLbl[i].setText("Timeout");
                                            SourcePage.this.m_testStatusLbl[i].setForeground(color);
                                            bl = false;
                                            SourcePage.this.aCustomDialog.stop();
                                            break;
                                        }
                                        case 3: {
                                            SourcePage.this.m_testStatusLbl[i].setVisible(true);
                                            SourcePage.this.m_testStatusLbl[i].setText("Cancel");
                                            SourcePage.this.m_testStatusLbl[i].setForeground(Color.blue);
                                            bl = false;
                                            SourcePage.this.aCustomDialog.stop();
                                            return;
                                        }
                                        case 204: {
                                            SourcePage.this.HandleUserInput();
                                            break;
                                        }
                                        default: {
                                            if (n >= 200 && n <= 242) {
                                                int n3 = n - 200;
                                                SourcePage.this.ConfirmVideo(n3);
                                                break;
                                            }
                                            SourcePage.this.m_testStatusLbl[i].setVisible(true);
                                            SourcePage.this.m_testStatusLbl[i].setText("Cancel");
                                            SourcePage.this.m_testStatusLbl[i].setForeground(Color.blue);
                                            bl = false;
                                            SourcePage.this.aCustomDialog.stop();
                                            break;
                                        }
                                        case 4: {
                                            SourcePage.this.m_testStatusLbl[i].setVisible(true);
                                            SourcePage.this.m_testStatusLbl[i].setText("Fail");
                                            SourcePage.this.m_testStatusLbl[i].setForeground(Color.red);
                                            bl = false;
                                            SourcePage.this.aCustomDialog.stop();
                                            break;
                                        }
                                        case 5: {
                                            SourcePage.this.m_testStatusLbl[i].setVisible(true);
                                            SourcePage.this.m_testStatusLbl[i].setText("Pass");
                                            SourcePage.this.m_testStatusLbl[i].setForeground(Color.green);
                                            bl = false;
                                            SourcePage.this.aCustomDialog.stop();
                                            break;
                                        }
                                        case 6: {
                                            SourcePage.this.m_testStatusLbl[i].setVisible(true);
                                            SourcePage.this.m_testStatusLbl[i].setText("Wait For User Action");
                                            SourcePage.this.m_testStatusLbl[i].setForeground(Color.orange);
                                            break;
                                        }
                                        case 100: {
                                            SourcePage.this.m_testStatusLbl[i].setVisible(true);
                                            SourcePage.this.m_testStatusLbl[i].setText("Skipped");
                                            SourcePage.this.m_testStatusLbl[i].setForeground(Color.blue);
                                            bl = false;
                                            SourcePage.this.aCustomDialog.stop();
                                            break;
                                        }
                                        case 101: {
                                            SourcePage.this.m_testStatusLbl[i].setVisible(true);
                                            SourcePage.this.m_testStatusLbl[i].setText("Warning");
                                            SourcePage.this.m_testStatusLbl[i].setForeground(Color.yellow);
                                            bl = false;
                                            SourcePage.this.aCustomDialog.stop();
                                            break;
                                        }
                                        case 102: {
                                            SourcePage.this.m_testStatusLbl[i].setVisible(true);
                                            SourcePage.this.m_testStatusLbl[i].setText("Not Judged");
                                            SourcePage.this.m_testStatusLbl[i].setForeground(Color.blue);
                                            bl = false;
                                            SourcePage.this.aCustomDialog.stop();
                                            break;
                                        }
                                        case 127: {
                                            SourcePage.this.m_testStatusLbl[i].setVisible(true);
                                            SourcePage.this.m_testStatusLbl[i].setText("Waiting to start");
                                            SourcePage.this.m_testStatusLbl[i].setForeground(Color.orange);
                                        }
                                    }
                                } while (bl);
                            }
                        }
                    });
                    thread.start();
                }
            }
            catch (InstrumentException instrumentException) {
                this.mainWin.setErrorMsg("Failed to start LLC Tests");
                return;
            }
        }
        if (actionEvent.getSource() == this.m_optionalTimeOut) {
            n = this.m_optionalTimeOut.isSelected() ? 1 : 0;
            try {
                this.mainWin.sendCmd("dprx:soto " + String.valueOf(n != 0));
            }
            catch (InstrumentException instrumentException) {
                this.mainWin.setErrorMsg("Failed to set timeout time");
                return;
            }
        }
        if (actionEvent.getSource() == this.m_batchMode) {
            n = this.m_batchMode.isSelected() ? 1 : 0;
            try {
                this.mainWin.sendCmd("dprx:taed " + String.valueOf(n));
            }
            catch (InstrumentException instrumentException) {
                this.mainWin.setErrorMsg("Failed to set Test Automation mode");
                return;
            }
        }
        if (actionEvent.getSource() == this.m_laneCount) {
            try {
                this.mainWin.sendCmd("dprx:lmlc " + String.valueOf(this.m_laneCount.getSelectedItem()));
            }
            catch (InstrumentException instrumentException) {
                this.mainWin.setErrorMsg("Failed to set Number of Lanes");
                return;
            }
        }
        if (actionEvent.getSource() == this.m_bitRate) {
            try {
                if (String.valueOf(this.m_bitRate.getSelectedItem()) == "2.7 Gbps") {
                    this.mainWin.sendCmd("dprx:lmbr 1");
                } else {
                    this.mainWin.sendCmd("dprx:lmbr 0");
                }
            }
            catch (InstrumentException instrumentException) {
                this.mainWin.setErrorMsg("Failed to set Bit Rate");
                return;
            }
        }
    }

    private void HandleCheckBox(ActionEvent actionEvent, int n) {
        if (actionEvent.getSource() == this.m_sourceTests[n]) {
            if (this.m_sourceTests[n].isSelected()) {
                this.m_itemItterSpn[n].setEnabled(true);
            } else {
                this.m_itemItterSpn[n].setEnabled(false);
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.m_waitTimeSpn) {
            if ((Integer)this.m_waitTimeSpn.getValue() < 0) {
                this.m_waitTimeSpn.setValue(new Integer(0));
            }
            try {
                this.mainWin.sendCmd("dprx:satw " + String.valueOf((Integer)this.m_waitTimeSpn.getValue()));
            }
            catch (InstrumentException instrumentException) {
                return;
            }
        }
        if (changeEvent.getSource() == this.m_hpdPulseDuration) {
            try {
                this.mainWin.sendCmd("dprx:hppw " + String.valueOf((Integer)this.m_hpdPulseDuration.getValue()));
            }
            catch (InstrumentException instrumentException) {
                return;
            }
        }
        if (changeEvent.getSource() == this.m_testItterSpn && (Integer)this.m_testItterSpn.getValue() < 1) {
            this.m_testItterSpn.setValue(new Integer(1));
        }
        for (int i = 0; i < this.SourceTestNums.length; ++i) {
            this.HandleItemSpn(changeEvent, i);
        }
    }

    private void HandleItemSpn(ChangeEvent changeEvent, int n) {
        if (changeEvent.getSource() == this.m_itemItterSpn[n] && (Integer)this.m_itemItterSpn[n].getValue() < 1) {
            this.m_itemItterSpn[n].setValue(new Integer(1));
        }
    }

    public void setWaitTimeSpn(int n) {
        this.m_waitTimeSpn.setValue(n);
    }

    public void setHpdPulseSpn(int n) {
        this.m_hpdPulseDuration.setValue(n);
    }

    public void setLaneCountBox(int n) {
        switch (n) {
            case 1: {
                this.m_laneCount.setSelectedIndex(0);
                break;
            }
            case 2: {
                this.m_laneCount.setSelectedIndex(1);
                break;
            }
            case 4: {
                this.m_laneCount.setSelectedIndex(2);
                break;
            }
            default: {
                this.m_laneCount.setSelectedIndex(-1);
            }
        }
    }

    public void setBitRateBox(String string) {
        if (string.lastIndexOf("High Rate") != -1) {
            this.m_bitRate.setSelectedIndex(1);
        } else {
            this.m_bitRate.setSelectedIndex(0);
        }
    }

    public void setTestAutomation(String string) {
        if (string.equals("0")) {
            this.m_batchMode.setSelected(false);
        } else {
            this.m_batchMode.setSelected(true);
        }
    }

    public void setOptTimeOut(String string) {
        if (string.equals("0")) {
            this.m_optionalTimeOut.setSelected(false);
        } else {
            this.m_optionalTimeOut.setSelected(true);
        }
    }

    public void ContinueTest(int n) {
        try {
            this.mainWin.sendCmd("dprx:lltr " + n);
        }
        catch (InstrumentException instrumentException) {
            return;
        }
    }

    public void UpdateStatus() {
        try {
            int n = this.mainWin.getInt("dprx:satw?");
            this.setWaitTimeSpn(n);
            n = this.mainWin.getInt("dprx:lmlc?");
            this.setLaneCountBox(n);
            String string = this.mainWin.sendCmd("dprx:lmbr?");
            this.setBitRateBox(string);
            string = this.mainWin.sendCmd("dprx:hppw?");
            n = Integer.parseInt(string.substring(0, string.length() - 3));
            this.setHpdPulseSpn(n);
            string = this.mainWin.sendCmd("dprx:taed?");
            this.setTestAutomation(string);
            string = this.mainWin.sendCmd("dprx:soto?");
            this.setOptTimeOut(string);
        }
        catch (InstrumentException instrumentException) {
            return;
        }
    }

    public void HandleUserInput() {
        String string = "Does The Video Look Good?";
        String string2 = "User Confirmation";
        int n = JOptionPane.showConfirmDialog(this, string, string2, 0, 3);
        try {
            String string3 = n == 0 ? "1" : "0";
            String string4 = "dprx:llui " + string3;
            this.mainWin.sendCmd(string4);
            Thread.sleep(100L);
        }
        catch (InstrumentException instrumentException) {
            this.mainWin.setErrorMsg("Failed to send user input");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void ConfirmVideo(int n) {
        JOptionPane.showMessageDialog(this, this.sPopupMessages[n]);
        try {
            String string = "dprx:llui 1";
            this.mainWin.sendCmd(string);
            Thread.sleep(100L);
        }
        catch (InstrumentException instrumentException) {
            this.mainWin.setErrorMsg("Failed to send user input");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

